﻿using Curse.CloudSearch;
using Curse.Friends.Enums;
using Curse.Friends.NotificationContracts;
using Nest;

namespace Curse.Friends.Data.Search
{
    public class GroupEventRole
    {
        [ElasticProperty(Name ="roleId", Type = FieldType.Integer, Index = FieldIndexOption.NotAnalyzed)]
        public int RoleID { get; set; }

        [AnalyzedStringProperty("name")]
        public string Name { get; set; }

        [ElasticProperty(Name="color", Type=FieldType.Integer, Index = FieldIndexOption.No)]
        public int Color { get; set; }

        [ElasticProperty(Name="badge", Type = FieldType.Integer, Index = FieldIndexOption.No)]
        public int Badge { get; set; }

        [ElasticProperty(Name="rank", Type=FieldType.Integer, Index = FieldIndexOption.No)]
        public int Rank { get; set; }

        [ElasticProperty(Name="permissions", Type=FieldType.Long, Index = FieldIndexOption.No)]
        public GroupPermissions Permissions { get; set; }

        public GroupEventRoleContract ToContract()
        {
            return new GroupEventRoleContract
            {
                RoleID = RoleID,
                Name = Name,
                Badge = Badge,
                Color = Color,
                Permissions = Permissions,
                Rank = Rank
            };
        }

    }
}