﻿using Curse.CloudSearch;
using Curse.Friends.NotificationContracts;
using Nest;

namespace Curse.Friends.Data.Search
{
    public class GroupEventRootGroup
    {
        [AnalyzedStringProperty("title")]
        public string Title { get; set; }

        [ElasticProperty(Name = "messageOfTheDay", Type = FieldType.String, Index = FieldIndexOption.Analyzed)]
        public string MessageOfTheDay { get; set; }

        [ElasticProperty(Name = "voiceRegion", Type = FieldType.Integer, Index = FieldIndexOption.No)]
        public int VoiceRegion { get; set; }

        [ElasticProperty(Name="afkTimerMinutes", Type = FieldType.Integer, Index = FieldIndexOption.No)]
        public int AfkTimerMinutes { get; set; }

        [ElasticProperty(Name = "isPublic", Type = FieldType.Boolean, Index = FieldIndexOption.No)]
        public bool IsPublic { get; set; }

        [ElasticProperty(Name="chatThrottleEnabled", Type = FieldType.Boolean, Index = FieldIndexOption.No)]
        public bool ChatThrottleEnabled { get; set; }

        [ElasticProperty(Name = "chatThrottleSeconds", Type = FieldType.Integer, Index = FieldIndexOption.No)]
        public int ChatThrottleSeconds { get; set; }

        [ElasticProperty(Name = "isSearchable", Type = FieldType.Boolean, Index = FieldIndexOption.No)]
        public bool IsSearchable { get; set; }

        [ElasticProperty(Name="searchTags", Type = FieldType.Integer, Index = FieldIndexOption.No)]
        public int[] SearchTags { get; set; }

        [ElasticProperty(Name="searchGames", Type=FieldType.Integer, Index = FieldIndexOption.No)]
        public int[] SearchGames { get; set; }

        [ElasticProperty(Name = "matchAllGames", Type = FieldType.Boolean, Index = FieldIndexOption.No)]
        public bool MatchAllGames { get; set; }

        [ElasticProperty(Name = "searchDescription", Type = FieldType.String, Index = FieldIndexOption.Analyzed)]
        public string SearchDescription { get; set; }

        public GroupEventGroupContract ToContract()
        {
            return new GroupEventGroupContract
            {
                Title = Title,
                SearchTags = SearchTags,
                ChatThrottleEnabled = ChatThrottleEnabled,
                IsPublic = IsPublic,
                ChatThrottleSeconds = ChatThrottleSeconds,
                MatchAllGames = MatchAllGames,
                IsSearchable = IsSearchable,
                AfkTimerMinutes = AfkTimerMinutes,
                MessageOfTheDay = MessageOfTheDay,
                SearchDescription = SearchDescription,
                SearchGames = SearchGames,
                VoiceRegion = VoiceRegion
            };
        }

    }
}