﻿using System;
using System.Security.Cryptography;

namespace Curse.Friends.Data.Utils
{
    public class ThreadSafeRandom
    {
        private static readonly RNGCryptoServiceProvider _seedProvider = new RNGCryptoServiceProvider();

        [ThreadStatic] private static Random _rand;

        private static Random GetOrCreate()
        {
            var rand = _rand;
            if (rand == null)
            {
                var bytes = new byte[4];
                _seedProvider.GetBytes(bytes);
                rand = new Random(BitConverter.ToInt32(bytes, 0));
                _rand = rand;
            }
            return _rand;
        }

        public static int Next()
        {
            var rand = GetOrCreate();        
            return rand.Next();
        }

        public static int Next(int max)
        {
            return Next()%max;
        }

        /// <summary>
        /// Reminder: Random.Range is [Inclusive],[Excusive]
        /// </summary>
        /// <param name="low"></param>
        /// <param name="high"></param>
        /// <returns></returns>
        public static int Next(int low, int high)
        {
            var rand = GetOrCreate();
            return rand.Next(low, high);
        }
    }
}