﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Curse.Friends.Enums
{
    public enum FriendPlatform
    {
        Unknown = 0,
        BattleNet,
        Steam,
        Facebook,
        Skype
    }

    public static class FriendPlatformExtensions
    {
        public static string ToFriendlyString(this FriendPlatform value)
        {
            switch (value)
            {
                case FriendPlatform.Unknown:
                    return null;
                case FriendPlatform.BattleNet:
                    return "Battle.net";
                default:
                    return value.ToString();
            }
        }
    }
}
