﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Curse.Friends.Enums
{
    public enum FriendshipStatus
    {
        AwaitingMe,
        AwaitingThem,
        /// <summary>
        /// The friendship is confirmed on both sided.
        /// </summary>
        Confirmed,
        /// <summary>
        /// The user declined to be friends by the other user.
        /// </summary>        
        DeclinedByMe,
        /// <summary>
        /// The user's request to be friends was declined by the other user.
        /// </summary>
        DeclinedByThem,

        Removing,
        /// <summary>
        /// The friendship is deleted and not blocked on either side.
        /// </summary>
        Deleted
    }
}
