﻿namespace Curse.Friends.Enums
{
    /// <summary>
    /// The type of change made to a group.
    /// </summary>
    public enum GroupChangeType
    {
        /// <summary>
        /// An unknown, invalid change type.
        /// </summary>
        Unknown,

        /// <summary>
        /// A new group was created.
        /// </summary>
        CreateGroup,

        /// <summary>
        /// Users were added to a group. (Metadata Only Group Notifications)
        /// </summary>
        AddUsers,

        /// <summary>
        /// Users were removed from a group. (Metadata Only Group Notifications)
        /// </summary>
        RemoveUsers,

        /// <summary>
        /// User info such as role was changed. (Metadata Only Group Notifications)
        /// </summary>
        UpdateUsers,

        /// <summary>
        /// The group's info such as title, avatar URL, access level, etc., was changed.
        /// </summary>
        ChangeInfo,

        /// <summary>
        /// A voice session was created for the group.
        /// </summary>
        VoiceSessionStarted,

        /// <summary>
        /// A voice session was closed for the group.
        /// </summary>
        VoiceSessionEnded,

        /// <summary>
        /// A user joined the group voice session.
        /// </summary>
        VoiceSessionUserJoined,

        /// <summary>
        /// A user left the group voice session.
        /// </summary>
        VoiceSessionUserLeft,

        /// <summary>
        /// A group was deleted. (Metadata Only Group Notifications)
        /// </summary>
        RemoveGroup,

        /// <summary>
        /// The group's subgroups were reordered and/or restructured. (Metadata Only Group Notifications)
        /// </summary>
        GroupReorganized,

        /// <summary>
        /// The group's permission levels changed.
        /// </summary>
        PermissionsChanged,

        /// <summary>
        /// The group's role names changed.
        /// </summary>
        RoleNamesChanged,

        /// <summary>
        /// The group's emoticons changed.
        /// </summary>
        UpdateEmoticons,

        UpdateUserPresence,

    }
}
