﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Curse.Friends.Enums
{
    public enum GroupEventCategory
    {
        Group,
        User,
        Giveaway,
        Poll,
        CommunityLink,
        Role,
        Channel,
        GuildLink,
    }

    public enum GroupEventType
    {
        // Group Events
        GroupCreated = 1,
        GroupDeleted,
        GroupSettingsChanged,

        // User Events
        UsersAdded=2001,
        UsersRemoved,
        UserRolesAdded,
        UserRolesRemoved,
        UserNickname,

        // Giveaway Events
        GiveawayStarted=3001,
        GiveawayRoll,
        GiveawayEnded,

        // Poll Events
        PollStarted=4001,
        PollEnded,

        // Community Link Events
        CommunityLinked=5001,
        CommunityUnlinked,
        CommunitySettingsChanged,

        // Channel Events
        ChannelCreated=6001,
        ChannelRemoved,
        ChannelInfoChanged,

        // Role Events
        RoleAdded=7001,
        RoleRemoved,
        RoleInfoChanged,

        // Guild Link Events
        GuildLinked = 8001,
        GuildUnlinked,
    }

    [Obsolete]
    public enum LegacyNewGroupEventType
    {
        // Group Events
        GroupCreated = 1,
        SubgroupCreated,
        SubgroupRemoved,
        SubgroupsReordered,

        // User Events
        UsersAdded = 2001,
        UsersRemoved,
        UserRolesAdded,
        UserRolesRemoved,

        // Giveaway Events
        GiveawayStarted = 3001,
        GiveawayRoll,
        GiveawayEnded,
        GiveawayCanceled,

        // Poll Events
        PollStarted = 4001,
        PollEnded,

        // Sync Events
        CommunityLinked = 5001,
        CommunityUnlinked,
    }

    [Obsolete]
    public enum LegacyGroupEventType
    {
        RootGroupCreated,
        SubgroupCreated,
        SubgroupRemoved,
        UserInvited,
        UsersAdded,
        UsersRemoved,
        UserLeft,
        UserPromoted,
        UserDemoted,
        GroupTitleChanged,
        GroupAvatarChanged
    }
}
