﻿using System;
using System.Runtime.Serialization;

namespace Curse.Friends.Enums
{
    [DataContract]
    [Flags]
    public enum GroupPermissions : long
    {
        [EnumMember]
        None = 0,
        [EnumMember]
        All = -1,

        /// <summary>
        /// Grants access to the server and/or channel
        /// </summary>
        [EnumMember]
        Access = 1,
                
        /// <summary>
        /// Allows a user to change the title, roles and other server-level settings.
        /// </summary>
        [EnumMember]
        ManageServer = 2,

        /// <summary>
        /// Allows a user to create, edit and delete channels.
        /// </summary>
        [EnumMember]
        ManageChannels = 4,

        /// <summary>
        /// Allows a user to create a temporary voice channel, within a channel that allows it.
        /// </summary>
        [EnumMember]
        CreateTemporaryGroup = 8,

        /// <summary>
        /// Allows a user to view the admin panel (included viewing analytics and other stats)
        /// </summary>
        [EnumMember]
        AccessAdminPanel = 16,

        /// <summary>
        /// Invites a user to a group/server
        /// </summary>
        [EnumMember]
        InviteUsers = 32,

        /// <summary>
        /// Remove a user from the group/server
        /// </summary>
        [EnumMember]
        RemoveUser = 64,
        
        /// <summary>
        /// Allows a user to view and delete any active server invitations
        /// </summary>
        [EnumMember]
        ManageInvitations = 128,

        /// <summary>
        /// Allows a user to promote or demote another user, at their rank or lower.
        /// </summary>
        [EnumMember]
        ChangeUserRole = 256,
        

        /// <summary>
        /// Allows a user to ban another user, at their rank or lower
        /// </summary>
        [EnumMember]
        BanUser = 512,


        // Voice Management        
        [EnumMember]
        VoiceKickUser = 1024,
        [EnumMember]
        VoiceMuteUser = 2048,
        [EnumMember]
        VoiceDeafenUser = 4096,
        [EnumMember]
        VoiceSpeak = 8192,
        [EnumMember]
        VoiceMoveUser = 16384,
        [EnumMember]
        VoiceChangeSettings = 32768,

        // Chat
        [EnumMember]
        ChatSendMessages = 65536,
        [EnumMember]
        ChatEmbedLinks = 131072,
        [EnumMember]
        ChatUploadPhotos = 262144,
        [EnumMember]
        ChatAttachFiles = 524288,
        [EnumMember]
        ChatReadHistory = 1048576,
        [EnumMember]
        ChatMentionUsers = 2097152,
        [EnumMember]
        ChatMentionEveryone = 4194304,
        [EnumMember]
        ChatBypassChatThrottle = 268435456,

        /// <summary>
        /// Allows a user to edit and delete another user's chat messages (at their rank or below)
        /// </summary>
        [EnumMember]
        ChatModerateMessages = 8388608,


        /// <summary>
        /// Allows a user to send a private message to another user, regardless if they are friends
        /// </summary>
        [EnumMember]
        SendPrivateMessage = 16777216,

        /// <summary>
        /// Allows a user to run a poll.
        /// </summary>
        [EnumMember]
        ManagePolls = 33554432L,

        /// <summary>
        /// Allows a user to run a giveaway.
        /// </summary>
        [EnumMember]
        ManageGiveaways = 67108864L,

        /// <summary>
        /// Allows a user to edit another user's chat messages (at their rank or below)
        /// </summary>
        [EnumMember]
        ChatEditOtherMessages = 134217728L,
    }
}
