﻿namespace Curse.Friends.Enums
{
    public enum TwitchChatNoticeType
    {
        // General
        Unknown = 0,
        AuthenticationFailed = 1,
        UserTimedOut,
        UserSubscribed,
        ChatCleared,
        Resub,
        Sub,

        // Whispers
        WhisperBanned=101,
        WhisperBannedRecipient,
        WhisperInvalidArgs,
        WhisperInvalidLogin,
        WhisperInvalidSelf,
        WhisperLimitPerMin,
        WhisperLimitPerSec,
        WhisperRestricted,
        WhisperRestrictedRecipient,

        // Room States
        SubsOnlyOn = 201,
        SubsOnlyOff,
        EmoteOnlyOn,
        EmoteOnlyOff,
        SlowModeOn,
        SlowModeOff,
        R9KOn,
        R9KOff,
        HostOn,
        HostOff,
        HostTargetWentOffline,
        FollowersOnlyOn,
        FollowersOnlyOff,
        FollowersOnlyOnZero,

        // Command Usage
        UnrecognizedCommand = 301,
        NoHelp,
        UsageMe,
        UsageHelp,
        UsageDisconnect,
        UsageMods,
        UsageSubsOn,
        UsageSubsOff,
        UsageEmoteOnlyOn,
        UsageEmoteOnlyOff,
        UsageSlowOn,
        UsageSlowOff,
        UsageR9kOn,
        UsageR9kOff,
        UsageClear,
        UsageColor,
        UsageCheerBadge,
        UsageTimeout,
        UsageMod,
        UsageUnmod,
        UsageBan,
        UsageUnban,
        UsageHost,
        UsageUnhost,
        UsageCommercial,
        UsageUntimeout,

        // Command Responses
        CmdsAvailable = 401,
        NoMods,
        RoomMods,
        NoPermission,
        AlreadySubsOn,
        AlreadySubsOff,
        AlreadyEmoteOnlyOn,
        AlreadyEmoteOnlyOff,
        AlreadyR9kOn,
        AlreadyR9kOff,
        TurboOnlyColor,
        ColorChanged,
        CheerBadgeDeselected,
        CheerBadgeSelected,
        NoCheerBadge,
        InvalidUser,

        // Timeouts
        BadTimeoutAnon = 501,
        BadTimeoutBroadcaster,
        BadTimeoutStaff,
        BadTimeoutAdmin,
        BadTimeoutGlobalMod,
        BadTimeoutSelf,
        BadTimeoutMod,
        BadTimeoutDuration,
        TimeoutSuccess,
        UntimeoutSuccess,
        UntimeoutIsBanned,
        TimeoutNoTimeout,

        // Bans
        BadBanAnon = 601,
        BadBanBroadcaster,
        BadBanStaff,
        BadBanAdmin,
        BadBanGlobalMod,
        BadBanSelf,
        BadBanMod,
        BadUnbanNoBan,
        AlreadyBanned,
        BanSuccess,
        UnbanSuccess,
        TosBanned,

        // Hosting
        BadHostSelf = 701,
        BadHostHosting,
        BadHostRejected,
        BadHostRateExceeded,
        BadHostError,
        HostsRemaining,
        HostSuccess,
        HostSuccessViewers,
        NotHosting,
        BadUnhostError,
        HostTaglineLengthError,

        // Commercials
        BadCommercialError = 801,
        CommercialSuccess,

        // Modding
        BadModBanned = 901,
        BadModMod,
        ModSuccess,
        BadUnmodMod,
        UnmodSuccess,

        // Misc Error
        BadSlowDuration = 1001,


        // Privmsg Responses
        MessageBanned = 1101,
        MessageTimedOut,
        MessageRateLimit,
        MessageDuplicate,
        MessageSubsOnly,
        MessageEmotesOnly,
        MessageVerifiedEmail,
        MessageSlowMode,
        MessageFacebook,
        MessageR9k,
        MessageConversationMode,
        MessageChannelSuspended,
        MessageSuspended,
        MessageRejected,
    }
}
