﻿using System;
using System.IO;
using System.Linq;
using System.Xml.Serialization;
using Curse.Friends.Configuration;
using Curse.Logging;

namespace Curse.Friends.FilesWebService.Configuration
{
    [XmlType("FileService")]
    public class FileServiceConfiguration
    {
        static FileServiceConfiguration()
        {
            // Try to load the config, based on the compilation mode

            Logger.Info("Current configuration is: " + FriendsServiceConfiguration.Mode);
            
            var configPath = FindConfigPath();

            Logger.Info("Loading service configuration from: " + configPath);

            using (var reader = new StreamReader(configPath))
            {
                var dcs = new XmlSerializer(typeof(FileServiceConfiguration));
                Global = (FileServiceConfiguration)dcs.Deserialize(reader);
            }

            var regionKey = RegionDiscovery.GetCurrentRegionKey();

            Logger.Info("Current region detected: " + regionKey);

            Current = Global.Buckets.First(b => b.RegionKey.Equals(regionKey, StringComparison.InvariantCultureIgnoreCase));            
        }

        private static string FindConfigPath()
        {
            var configPath = Path.Combine(AppDomain.CurrentDomain.BaseDirectory, "Configuration", "FileService." + FriendsServiceConfiguration.Mode + ".config");

            if (!File.Exists(configPath))
            {
                configPath = Path.Combine(AppDomain.CurrentDomain.BaseDirectory, "bin", "Configuration", "FileService." + FriendsServiceConfiguration.Mode + ".config");
            }

            if (!File.Exists(configPath))
            {
                throw new Exception("Configuration could not be loaded from '" + configPath + "'");
            }

            return configPath;
        }


        public static FileServiceConfiguration Global { get; set; }

        public static FileServiceBucketConfiguration Current { get; set; }

        [XmlElement]
        public int ThrottleWindowMinutes { get; set; }

        [XmlElement]
        public int MaxRequestsPerWindow { get; set; }

        [XmlElement]
        public int MaxSizePerWindow { get; set; }

        [XmlElement("Bucket")]
        public FileServiceBucketConfiguration[] Buckets { get; set; }
    }
}