﻿using System;
using System.Collections.Generic;
using Curse.Friends.Data;

namespace Curse.Friends.FilesWebService.Manager
{
    public class FileMetadata
    {
        public const string FilenameKey = "filename";
        public const string FileSizeKey = "filesize";
        public const string UploaderUserIDKey = "uploaderid";
        public const string DateUploadedKey = "dateuploaded";

        public string Filename { get; private set; }

        public string ContentType { get; private set; }

        public DateTime DateUploaded { get; private set; }
 
        public int FileSize { get; private set; }
        
        public int UploaderUserID { get; private set; }

        public Dictionary<string, string> AdditionalMetadata { get; private set; }

        public FileMetadata(int uploaderID, string filename, int fileSize, DateTime dateUploaded, string contentType, Dictionary<string, string> metadata = null)
        {
            UploaderUserID = uploaderID;
            Filename = filename;
            FileSize = fileSize;
            DateUploaded = dateUploaded;
            ContentType = contentType;
            AdditionalMetadata = metadata ?? new Dictionary<string, string>();
        }

        public static FileMetadata FromAttachment(Attachment attachment)
        {
            return new FileMetadata(attachment.UploaderUserID, attachment.Filename, attachment.FileSize, attachment.DateUploaded, attachment.FileType);
        }
    }
}