﻿using System.IO;
using System.Net.Sockets;
using Curse.Friends.FilesWebService.Configuration;
using Curse.Friends.MicroService;
using Curse.Friends.MicroService.Exceptions;
using Curse.Logging;
using nClam;

namespace Curse.Friends.FilesWebService.Manager
{
    public class VirusScanner
    {
        public static void Scan(Stream stream)
        {
            Scan(stream, FileServiceConfiguration.Current.ScanHost, FileServiceConfiguration.Current.ScanPort, MicroServiceApplication.MaxContentLength);
        }

        public static void Scan(Stream stream, string address, int port, int maxFileSizeBytes)
        {
            var client = new ClamClient(address, port)
            {
                MaxStreamSize = maxFileSizeBytes,
            };

            try
            {
                var result = client.SendAndScanFile(stream);

                switch (result.Result)
                {
                    case ClamScanResults.VirusDetected:
                        throw new FileUploadException(FileUploadFailureReason.VirusDetected);
                    case ClamScanResults.Error:
                    case ClamScanResults.Unknown:
                        Logger.Warn(string.Format("Error scanning Clam AV at {0}:{1}", address, port));
                        throw new FileUploadException(FileUploadFailureReason.VirusScanError);
                }

                stream.Seek(0, SeekOrigin.Begin);
            }
            catch (SocketException ex)
            {
                Logger.Warn(ex, string.Format("Error communicating with Clam AV at {0}:{1}", address, port));
                throw new FileUploadException(FileUploadFailureReason.VirusScanError);
            }
        }

    }
}