﻿using System;
using System.IO;
using System.Web;
using Curse.Friends.FilesWebService.Manager;
using Curse.Friends.MicroService.Extensions;

namespace Curse.Friends.FilesWebService.Models
{
    public class SharedFile
    {
        public FileMetadata Metadata { get; private set; }

        public Stream Content { get; private set; }

        public SharedFile(FileMetadata metadata, Stream content)
        {
            Metadata = metadata;
            Content = content;
        }

        public static SharedFile FromUploadedFile(int requestorID, HttpPostedFile file)
        {
            var filename = HttpUtility.UrlEncode(file.FileName.RemoveSpecialCharacters());
            var contentType = string.IsNullOrEmpty(file.ContentType) ? MimeMapping.GetMimeMapping(filename) : file.ContentType;
            var fileMetadata = new FileMetadata(requestorID, filename, file.ContentLength, DateTime.UtcNow, contentType);
            return new SharedFile(fileMetadata, file.InputStream);
        }
    }
}