﻿using Curse.Friends.Data;
using Curse.Friends.FilesWebService.Manager;

namespace Curse.Friends.FilesWebService.Models
{
    public class SharedFileInfo
    {
        public string Url { get; private set; }

        public string ID { get; private set; }

        public FileMetadata Metadata { get; private set; }

        public SharedFileInfo(string url, string id, FileMetadata metadata)
        {
            Url = url;
            ID = id;
            Metadata = metadata;
        }

        public static SharedFileInfo FromAttachment(Attachment attachment)
        {
            return new SharedFileInfo(attachment.Url, attachment.FileID.ToString(), FileMetadata.FromAttachment(attachment));
        }
    }
}
