﻿using System;
using System.Diagnostics;
using System.ServiceProcess;

namespace Curse.Friends.GiveawayService
{
    static class Program
    {
        /// <summary>
        /// The main entry point for the application.
        /// </summary>
        static void Main()
        {
            if (Debugger.IsAttached)
            {
                Console.Write("Starting Giveaway Service...");
                var service = new GiveawayService();
                service.OnDebugStart();
                Console.WriteLine("Done!");

                Console.WriteLine("Press enter to exit");
                Console.ReadLine();

                Console.Write("Stopping service...");
                service.OnDebugStop();
                Console.WriteLine("Done");
            }
            else
            {
                var ServicesToRun = new ServiceBase[]
                {
                    new GiveawayService()
                };
                ServiceBase.Run(ServicesToRun);
            }
        }
    }
}
