﻿using System;
using System.Collections.Concurrent;
using System.Timers;
using Curse.Friends.Data;

namespace Curse.Friends.GiveawayService
{
    public class ResponseWindowTimer : IDisposable
    {
        private static readonly ConcurrentDictionary<string, ResponseWindowTimer> _timers = new ConcurrentDictionary<string, ResponseWindowTimer>();

        public static void Start(string key, TimeSpan timeout, Action action)
        {
            var timer = new ResponseWindowTimer(timeout, action);
            if (_timers.TryAdd(key, timer))
            {
                timer.Start();
            }
            else
            {
                // Dispose this as it won't be used due to a conflict
                timer.Dispose();
                throw new DataConflictException();
            }
        }

        public static bool Stop(string key)
        {
            ResponseWindowTimer timer;
            if (_timers.TryRemove(key, out timer))
            {
                timer.Stop();
                timer.Dispose();
                return true;
            }
            return false;
        }

        private readonly Timer _timer;
        private readonly Action _action;

        private ResponseWindowTimer(TimeSpan delay, Action action)
        {
            _action = action;
            _timer = new Timer(delay.TotalMilliseconds) { AutoReset = false };
            _timer.Elapsed += TimerElapsed;
        }

        private void Start()
        {

            _timer.Start();
        }

        private void Stop()
        {
            _timer.Stop();
        }

        private void TimerElapsed(object sender, ElapsedEventArgs args)
        {
            _action();
        }

        public void Dispose()
        {
            _timer.Elapsed -= TimerElapsed;
            _timer.Dispose();
        }
    }

}
