﻿using System.Collections.Generic;

namespace Curse.Friends.GiveawaysWebService.Contracts
{
    public class CreateGiveawayRequest
    {
        /// <summary>
        /// The title of the giveaway.
        /// </summary>
        public string Title { get; set; }

        /// <summary>
        /// Whether or not to automatically enter all users who are active.
        /// </summary>
        public bool AutoEnterActiveUsers { get; set; }

        /// <summary>
        /// The roles that should be auto-entered into the giveaway.
        /// </summary>
        public HashSet<int> AutoEnterRoles { get; set; }

        /// <summary>
        /// The roles that will automatically claim the prize instead of having to respond.
        /// </summary>
        public HashSet<int> AutoClaimRoles { get; set; }

        /// <summary>
        /// The number of rolls to perform before picking the actual winner.
        /// </summary>
        public int RollsBeforeWinner { get; set; }

        /// <summary>
        /// The mapping of role to bonus chance to win.
        /// </summary>
        public Dictionary<int, int> RoleBonuses { get; set; }

        /// <summary>
        /// The number of seconds the winner is given to claim the prize.
        /// </summary>
        public int ResponseWindowSeconds { get; set; }

        /// <summary>
        /// Collection of roles that the user must have at least one of to win the giveaway.
        /// </summary>
        public HashSet<int> RequiredRoles { get; set; }

        /// <summary>
        /// Whether or not to allow someone who has won in this giveaway to win again.
        /// </summary>
        public bool AllowRepeatWinners { get; set; }

        /// <summary>
        /// IDs of users to disallow entry into the giveaway.
        /// </summary>
        public HashSet<int> IgnoredUsers { get; set; } 

        /// <summary>
        /// The bonus chance to win for each time a participant shares the giveaway link.
        /// </summary>
        public int SharingBonus { get; set; }

        /// <summary>
        /// Whether or not offline members should be considered for auto-enter and rolls.
        /// </summary>
        public bool IncludeOfflineMembers { get; set; }
    }
}