﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Curse.Extensions;
using Curse.Friends.Data;
using Curse.Friends.Data.Search;
using Curse.Friends.Enums;
using Elasticsearch.Net;
using Nest;

namespace Curse.Friends.GroupEventTests
{
    public class ExternalCommunityMemberTest
    {
        public static void Test()
        {
            var client = ExternalCommunityMemberManager.GetClient();

            Console.WriteLine("Reset everything? (Y|N)");
            if (Console.ReadKey(true).Key == ConsoleKey.Y)
            {
                client.DeleteIndex(i => i.Index("externalcommunitymembers-index"));
                client.DeleteTemplate("externalcommunitymembers-template");

                client.PutTemplate("externalcommunitymembers-template", t => t
                    .Template("externalcommunitymembers-*")
                    .AddMapping<ExternalCommunityMemberSearchModel>(m => m
                        .MapFromAttributes()
                        .AllField(af => af.Enabled(false))
                        .SourceField(sf => sf.Enabled())));
            }

            Console.WriteLine("Index test data? (Y|N)");
            if (Console.ReadKey(true).Key == ConsoleKey.Y)
            {
                AddUsers(client);
            }

            var search = new ExternalCommunityMemberSearch
            {
                PageSize = 10,
                PageNumber = 1,
                ExternalCommunityID = "meandaenie",
                ExternalCommunityType = ExternalAccountType.Twitch,
                ExternalUsername = "only_jaximus"
            };

            var results = ExternalCommunityMemberManager.Search(search);

            long actives = 0;
            long inactives = 0;
            ExternalCommunityMemberManager.CountByStatus("meandaenie",ExternalAccountType.Twitch, TwitchRoleType.Subscriber.ToString(), out actives, out inactives);

            #region temp

            //while (true)
            //{
            //    Console.Clear();
            //    Console.WriteLine("What community do you want to search for? (1-10)");
            //    var community = int.Parse(Console.ReadLine());
            //    Console.WriteLine("What role do you want to search for? (Follower|Subscriber|Moderator|Owner)");
            //    var role = Console.ReadLine();

            //    Console.WriteLine("Searching");

            //    var results = ExternalCommunityMemberManager.Search(new ExternalCommunityMemberSearch
            //    {
            //        ExternalCommunityID = community > 0 ? "community" + community : null,
            //        ExternalCommunityType = ExternalAccountType.Twitch,
            //        ExternalCommunityRoles = !string.IsNullOrWhiteSpace(role) ? new[] {role} : null,
            //        PageSize = 20
            //    });

            //    Console.WriteLine("Total results: {0} (Truncated if exceeds {1})", results.Length, 20);
            //    foreach (var result in results)
            //    {
            //        WriteMember(result);
            //    }

            //    Console.WriteLine("Do you want to search again? (Y|N)");
            //    if (Console.ReadKey(true).Key != ConsoleKey.Y)
            //    {
            //        break;
            //    }
            //}

            #endregion
        }

        static void AddUsers(ElasticClient client)
        {
            var membersToAdd = new List<ExternalCommunityMemberSearchModel>();
            for (int i = 1; i <= 10; i++)
            {
                var communityName = "community" + i;
                for (int j = 1; j <= 10; j++)
                {
                    var username = "external" + j;
                    var extRoles = i == j ? new[] {"Owner"} : j%2 == 0 ? new[] {"Follower"} : new[] {"Follower", "Moderator"};
                    foreach (var extRole in extRoles)
                    {
                        var deleted = j%5 == 4;
                        var membership = new ExternalCommunityMembership
                        {
                            ExternalCommunityID = communityName,
                            ExternalUserID = username,
                            Type = i%2 == 0 ? ExternalAccountType.Twitch : ExternalAccountType.Twitch, // Temporarily not including YouTube
                            Role = extRole,
                            ExternalCommunityName = communityName.ToUpper(),
                            ExternalUsername = username.ToUpper(),
                            Status = deleted ? ExternalCommunityMembershipStatus.Deleted : ExternalCommunityMembershipStatus.Active,
                            CurrentRoleDate = DateTime.UtcNow.AddMonths(-j),
                            FirstRoleDate = DateTime.UtcNow.AddYears(-j),
                        };
                        var member = new ExternalCommunityMemberSearchModel(membership,new []{j});
                        membersToAdd.Add(member);
                    }
                }
            }

            var request = new BulkRequest
            {
                Index = "externalcommunitymembers-index",
                Consistency = Consistency.One,
                Refresh = true,
                Operations = membersToAdd.Select(m => (IBulkOperation) new BulkIndexDescriptor<ExternalCommunityMemberSearchModel>().Document(m).Id(m.ModelID)).ToList()
            };
            client.Bulk(request);
        }

        private static void WriteMember(ExternalCommunityMemberSearchModel member)
        {
            Console.WriteLine("-------------");
            Console.WriteLine("ID: {0}, Deleted: {1}", member.ModelID, member.IsDeleted);
            Console.WriteLine("Community: {0} ({1}), Type: {2}", member.ExternalCommunityName, member.ExternalCommunityID, member.ExternalCommunityType);
            Console.WriteLine("User: {0} ({1}), Role: {2}", member.ExternalUsername, member.ExternalUserID, member.ExternalCommunityRole);
            Console.WriteLine("Times: First: {0}, Current: {1}", member.FirstRoleDate.FromEpochMilliconds().ToString("g"), member.CurrentRoleDate.FromEpochMilliconds().ToString("g"));
            Console.WriteLine("-------------");
        }
    }
}
