﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Curse.Extensions;
using Curse.Friends.Data.Search;

namespace Curse.Friends.GroupEventTests
{
    public class GroupBannedUserTest
    {
        public static void Test()
        {
            var group1 = new Guid("{03C793FE-AC14-47AA-AFDB-854CAE83DAA1}");
            var group2 = new Guid("{291E771D-070B-411C-865A-1EB7016377D7}");

            Console.WriteLine("Delete everything and start over? (Y|N)");
            if (Console.ReadKey(true).Key == ConsoleKey.Y)
            {
                var client = GroupBannedUserSearchManager.GetClient();
                client.DeleteIndex(d => d.Index("bannedusers-index"));
                client.DeleteTemplate("bannedusers-template");
                client.PutTemplate("bannedusers-template", t => t
                    .Template("bannedusers-*")
                    .AddMapping<GroupBannedUserSearchManager>(m => m
                        .SourceField(sf => sf.Enabled())
                        .AllField(af => af.Enabled(false))
                        .MapFromAttributes()));
            }

            Console.WriteLine("Create test data? (Y|N)");
            if (Console.ReadKey(true).Key == ConsoleKey.Y)
            {
                foreach (var group in new[] {group1, group2})
                {
                    for (int i = 1; i < 20; i++)
                    {
                        GroupBannedUserSearchManager.Index(new GroupBannedUserSearchModel
                        {
                            GroupID = group,
                            IsDeleted = i%5 == 0,
                            ModelID = GroupBannedUserSearchModel.GetModelID(group, i),
                            UserID = i,
                            Username = "User" + i,
                            Reason = i%2 == 0 ? "troll" : "spam",
                            RequestorUserID = i + 1,
                            RequestorUsername = "User" + (i + 1),
                            StatusTimestamp = DateTime.UtcNow.ToEpochMilliseconds()
                        });
                    }
                }
            }

            Console.ReadKey(true);

            Console.Clear();
            var searchResults = GroupBannedUserSearchManager.Search(new GroupBannedUserSearch
            {
                GroupID = group1,
                PageNumber = 1,
                PageSize = 30,
            });
            PrintResults(searchResults);
            Console.ReadKey(true);

            Console.Clear();
            var searchResults2 = GroupBannedUserSearchManager.Search(new GroupBannedUserSearch
            {
                GroupID = group2,
                PageNumber = 1,
                PageSize = 20,
                Query = "troll"
            });
            PrintResults(searchResults2);
            Console.ReadKey(true);

            Console.Clear();
            var searchResults3 = GroupBannedUserSearchManager.Search(new GroupBannedUserSearch
            {
                GroupID = group2,
                PageNumber = 1,
                PageSize = 10,
                Username = "user1"
            });
            PrintResults(searchResults3);
            Console.ReadKey(true);

            Console.Clear();
            var getResult = GroupBannedUserSearchManager.GetByID(group1, 5);
            PrintResults(new[] {getResult});
            Console.ReadKey(true);

        }

        private static void PrintResults(GroupBannedUserSearchModel[] results)
        {
            Console.WriteLine("Total results: {0}", results.Length);

            foreach (var result in results)
            {
                Console.WriteLine("Group: {0}, User: {1}, Reason: {2}", result.GroupID, result.Username, result.Reason);
            }
        }
    }
}
