﻿using Elasticsearch.Net.ConnectionPool;
using Nest;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Curse.Extensions;
using System.Diagnostics;
using Curse.Friends.Configuration;
using Aerospike.Client;
using System.Threading;
using System.Collections.Concurrent;
using Curse.CloudSearch;
using Curse.Friends.Data.Models;
using Curse.Friends.Data.Search;
using Elasticsearch.Net;
using Curse.Friends.Enums;

namespace Curse.Friends.GroupEventTests
{
    class Program
    {
        static void Main(string[] args)
        {

            StorageConfiguration.Initialize("FrameworkTests", "US-East", ConfigurationMode.Debug, ConfigurationServices.Database | ConfigurationServices.Search);

            try
            {
                while (true)
                {
                    Console.Clear();
                    Console.WriteLine("Welcome to the Elasticsearch test app. This app is designed to quickly prototype out framework-level improvements to our Aerospike wrapper.");
                    Console.WriteLine("0: Test group events");
                    Console.WriteLine("1. Test group members.");
                    Console.WriteLine("2. Test external community members.");
                    Console.WriteLine("3. Test groups.");
                    Console.WriteLine("4: Test banned users.");

                    var selection = Console.ReadKey(true).Key;
                    Console.Clear();

                    switch (selection)
                    {
                        case ConsoleKey.Escape:
                            return;
                        case ConsoleKey.D0:
                            GroupEventsTest.Test();
                            return;
                        case ConsoleKey.D1:
                            GroupMembersTest.Test();
                            break;
                        case ConsoleKey.D2:
                            ExternalCommunityMemberTest.Test();
                            break;
                        case ConsoleKey.D3:
                            GroupsTest.Test();
                            break;
                        case ConsoleKey.D4:
                            GroupBannedUserTest.Test();
                            break;
                        default:
                            Console.WriteLine("Invalidation selection! Press any key to continue...");
                            Console.ReadKey(true);
                            continue;

                    }
                }
            }
            catch (Exception ex)
            {
                Console.WriteLine("General error: " + ex.Message);
                Console.ReadLine();
            }
        }
    }
}
