﻿using System;
using System.Reflection;

namespace Curse.Friends.GroupService
{
    public static class AssemblyExtensions
    {
        public static DateTime GetBuildDate(this Assembly assembly)
        {
            var version = Assembly.GetEntryAssembly().GetName().Version;
            var buildDateTime = new DateTime(2000, 1, 1).Add(new TimeSpan(
            TimeSpan.TicksPerDay * version.Build + // days since 1 January 2000
            TimeSpan.TicksPerSecond * 2 * version.Revision));
            return buildDateTime;
        }

        public static TimeSpan GetBuildAge(this Assembly assembly)
        {
            return DateTime.UtcNow.Subtract(assembly.GetBuildDate());
        }
    }
}
