﻿using System;
using Curse.Friends.Data;

namespace Curse.Friends.GroupService
{
    public class GroupMemberEndpointCache
    {
        public ClientEndpoint Endpoint { get; private set; }

        public Guid CurrentGroupID { get; private set; }

        public GroupMemberEndpointCache(ClientEndpoint endpoint)
        {
            Endpoint = endpoint;
            CurrentGroupID = endpoint.CurrentGroup;
        }

        public void Update(ClientEndpoint endpoint)
        {
            if (endpoint.CurrentGroupTimestamp > Endpoint.CurrentGroupTimestamp)
            {
                CurrentGroupID = endpoint.CurrentGroup;
            }

            Endpoint = endpoint;
        }
    }
}
