﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Xml.Serialization;
using Curse.Friends.Configuration;
using Curse.Friends.MicroService;

namespace Curse.Friends.GroupsWebService.Configuration
{
    [XmlType("GroupsWeb")]
    public class GroupsWebConfiguration
    {
        private static readonly GroupsWebConfiguration _instance;

        public static GroupsWebConfiguration Instance { get { return _instance; } }

        static GroupsWebConfiguration()
        {
            _instance = ConfigHelper.LoadConfig<GroupsWebConfiguration>(FriendsServiceConfiguration.Mode, "GroupsWeb");
        }

        [XmlElement]
        public string GroupInviteUrlFormat { get; set; }

        [XmlElement]
        public Guid PartnerServerID { get; set; }
    }
}