﻿using System;
using System.Collections.Generic;
using System.Text.RegularExpressions;
using Curse.Friends.MicroService;

namespace Curse.Friends.GroupsWebService.Contracts
{
    public class AddEmoticonRequest : BaseRequestContract
    {
        public string Regex { get; set; }

        public string Url { get; set; }

        public HashSet<int> RequiredRoles { get; set; }

        protected override bool DoValidate()
        {
            if (string.IsNullOrWhiteSpace(Regex))
            {
                return false;
            }


            try
            {
                new Regex(Regex);
            }
            catch
            {
                return false;
            }

            if (string.IsNullOrWhiteSpace(Url))
            {
                return false;
            }

            try
            {
                new Uri(Url);
            }
            catch
            {

                return false;
            }


            return true;
        }
    }
}