﻿using System.Linq;
using Curse.Extensions;
using Curse.Friends.Data;
using Curse.Friends.Enums;
using Curse.Friends.MicroService;

namespace Curse.Friends.GroupsWebService.Contracts
{
    public class CreateChannelRequest : BaseRequestContract
    {
        public string Title { get; set; }
        public GroupMode Mode { get; set; }
        public bool IsPublic { get; set; }
        public int[] AccessRoles { get; set; }
        public GroupDisplayCategory DisplayCategory { get; set; }
        public bool HideNoAccess { get; set; }
        public bool HideCallMembersNoAccess { get; set; }

        protected override bool DoValidate()
        {
            if (!Title.SafeRange(1, Group.ChannelTitleMaxLength))
            {
                return false;
            }

            if (AccessRoles == null)
            {
                AccessRoles = new int[0];
            }

            if (IsPublic && AccessRoles.Any())
            {
                return false;
            }

            if (!IsPublic && !AccessRoles.Any())
            {
                return false;
            }

            if (DisplayCategory != null && !DisplayCategory.IsValid())
            {
                return false;
            }

            return true;
        }
    }
}