﻿using System.Collections.Generic;
using Curse.Friends.MicroService;
using Curse.Friends.Data;
using Curse.Extensions;

namespace Curse.Friends.GroupsWebService.Contracts
{
    public class CreateGroupRequest : BaseRequestContract
    {
                        
        public HashSet<int> RecipientsUserIDs { get; set; }
        public string Title { get; set; }
        public string OwnerRoleName { get; set; }
        public string MemberRoleName { get; set; }
        
        protected override bool DoValidate()
        {
            if (Title.SafeLength() > Group.TitleMaxLength)
            {
                _validationMessage = "Title is too long!";
                return false;
            }

            if (RecipientsUserIDs == null || RecipientsUserIDs.Count == 0 || RecipientsUserIDs.Count > Group.MaxUsersInGroup)
            {
                return false;
            }

            return true;
        }
    }
}