﻿using Curse.Extensions;
using Curse.Friends.Data;
using Curse.Friends.Enums;
using Curse.Friends.MicroService;

namespace Curse.Friends.GroupsWebService.Contracts
{
    public class CreateGroupRoleRequest : BaseRequestContract
    {       
        public string Name { get; set; }
        public int VanityColor { get; set;}
        public int VanityBadge { get; set; }
        public bool HasCustomVanityBadge { get; set; }
        public GroupPermissions Permissions { get; set; }

        protected override bool DoValidate()
        {

            if (VanityColor < 0 || VanityColor > GroupRole.MaxVanityColors)
            {
                _validationMessage = "Vanity color must be between 0 and " + GroupRole.MaxVanityColors;
                return false;
            }

            if (VanityBadge < 0 || VanityBadge > GroupRole.MaxVanityBadges)
            {
                _validationMessage = "Vanity badge must be between 0 and " + GroupRole.MaxVanityBadges;
                return false;
            }

            if (Name.SafeLength() < 1 || Name.SafeLength() > GroupRole.NameMaxLength)
            {
                _validationMessage = "Role name cannot be longer than " + GroupRole.NameMaxLength + " characters!";
                return false;
            }
            
            return true;
        }
    }
}