﻿using Curse.Extensions;
using Curse.Friends.Data;
using Curse.Friends.MicroService;

namespace Curse.Friends.GroupsWebService.Contracts
{
    public class CreateServerRequest : BaseRequestContract
    {
        public string Title { get; set; }
        public string TextChannelTitle { get; set; }
        public string VoiceChannelTitle { get; set; }
        public string OwnerRoleName { get; set; }
        public string GuestRoleName { get; set; }
        public string ModeratorRoleName { get; set; }
        public bool IsPublic { get; set; }
        public bool IsSynced { get; set; }

        protected override bool DoValidate()
        {
            if (!Title.SafeRange(1, Group.TitleMaxLength))
            {
                _validationMessage = "Title is too short or long.";
                return false;
            }

            if (!TextChannelTitle.SafeRange(1, Group.TitleMaxLength))
            {
                _validationMessage = "Text channel title is too short or too long.";
                return false;
            }

            if (!VoiceChannelTitle.SafeRange(1, Group.TitleMaxLength))
            {
                _validationMessage = "Voice channel title is too short or too long.";
                return false;
            }
            
            if (!OwnerRoleName.SafeRange(1, GroupRole.NameMaxLength))
            {
                _validationMessage = "OwnerRoleName is too short or too long.";
                return false;
            }

            if (!ModeratorRoleName.SafeRange(1, GroupRole.NameMaxLength))
            {
                _validationMessage = "ModeratorRoleName is too short or too long.";
                return false;
            }

            if (!GuestRoleName.SafeRange(1, GroupRole.NameMaxLength))
            {
                _validationMessage = "GuestRoleName is too short or too long.";
                return false;
            }
            

            return true;
        }
    }
}
