﻿using System.Linq;
using Curse.Extensions;
using Curse.Friends.Data;
using Curse.Friends.Enums;
using Curse.Friends.MicroService;
using Curse.Friends.GroupsWebService.Utils;

namespace Curse.Friends.GroupsWebService.Contracts
{
    public class SyncedStreamInfo
    {
        public string ExternalAccountID { get; set; }

        public AccountType Type { get; set; }

        public string PremiumChannelName { get; set; }
    }



    public class CreateStreamerCommunityGroupRequest : BaseRequestContract
    {
        public string ServerName { get; set; }

        public string DefaultTextChannelName { get; set; }

        public string DefaultVoiceChannelName { get; set; }

        public string OwnerRoleName { get; set; }        

        public string GuestRoleName { get; set; }

        public bool IsPublic { get; set; }

        public string CustomUrl { get; set; }

        public SyncedStreamInfo[] SyncedStreams { get; set; }

        protected override bool DoValidate()
        {

            if (!string.IsNullOrWhiteSpace(CustomUrl) && !VanityUrlValidator.IsValid(CustomUrl))
            {
                _validationMessage = "Invalid custom URL: " + CustomUrl;
                return false;
            }

            if (SyncedStreams == null || SyncedStreams.Length < 0 || SyncedStreams.Length > 20)
            {
                _validationMessage = "Too few or too many synced streams specified";
                return false;
            }
            
            if (!ServerName.SafeRange(1, Group.TitleMaxLength))
            {
                _validationMessage = "Server name not specified or too long";
                return false;
            }

            if (!DefaultTextChannelName.SafeRange(1, Group.TitleMaxLength))
            {
                _validationMessage = "Default text channel name not specified or too long";
                return false;
            }

            if (!DefaultVoiceChannelName.SafeRange(1, Group.TitleMaxLength))
            {
                _validationMessage = "Default voice channel name not specified or too long";
                return false;
            }

            if (!OwnerRoleName.SafeRange(1, GroupRole.NameMaxLength))
            {
                _validationMessage = "Owner role name not specified or too long";
                return false;
            }

            if (!GuestRoleName.SafeRange(1, GroupRole.NameMaxLength))
            {
                _validationMessage = "Guest role name not specified or too long";
                return false;
            }

            return true;
        }
    }
}