﻿using Curse.Extensions;
using Curse.Friends.Data;
using Curse.Friends.Enums;

namespace Curse.Friends.GroupsWebService.Contracts
{
    public class CreateSyncedGuildServerRequest : CreateGuildCommunityRequest
    {
        public GroupSubType Subtype { get; set; }

        public string DefaultVoiceChannelName { get; set; }

        public SyncedGuild[] Guilds { get; set; }

        public string AvatarUrl { get; set; }

        protected override bool DoValidate(out GuildServerCreationErrorType errorType)
        {
            if (!DefaultVoiceChannelName.SafeRange(1, Group.ChannelTitleMaxLength))
            {
                _validationMessage = "Default Voice Chat Title Length";
                errorType = GuildServerCreationErrorType.DefaultVoiceChatNameLength;
                return false;
            }

            if (Guilds == null || Guilds.Length == 0 || Guilds.Length > 10)
            {
                _validationMessage = "Guilds Length";
                errorType = GuildServerCreationErrorType.SyncedGuildCount;
                return false;
            }

            foreach (var guild in Guilds)
            {
                if (guild.GameRegion < 1)
                {
                    _validationMessage = "Guild Region";
                    errorType = GuildServerCreationErrorType.SyncedGuildRegion;
                    return false;
                }

                if (!guild.GameServer.SafeRange(1, 256))
                {
                    _validationMessage = "Guild Game Server Length";
                    errorType = GuildServerCreationErrorType.SyncedGuildGameServerLength;
                    return false;
                }

                if (!guild.Name.SafeRange(1, 256))
                {
                    _validationMessage = "Guild Name Length";
                    errorType = GuildServerCreationErrorType.SyncedGuildNameLength;
                    return false;
                }
            }

            errorType = GuildServerCreationErrorType.NoError;
            return true;
        }
    }

    public class SyncedGuild
    {
        public AccountType Type { get; set; }

        public int GameRegion { get; set; }

        public string GameServer { get; set; }

        public string Name { get; set; }

        public SyncedGuildRole[] RolesToCreate { get; set; }
    }

    public class SyncedGuildRole : GuildCommunityRoleContract
    {
        public GroupRoleTag Tag { get; set; }
    }
}