﻿using System;
using Curse.Extensions;
using Curse.Friends.Data;
using Curse.Friends.Data.Search;
using Curse.SocketMessages;

namespace Curse.Friends.GroupsWebService.Contracts
{
    [ServiceContract(ServiceContractDirection.Embedded)]
    public class GroupBannedUserContract
    {
        public Guid GroupID { get; set; }

        public string GroupTitle { get; set; }

        public int UserID { get; set; }

        public string Username { get; set; }

        public int RequestorUserID { get; set; }

        public string RequestorUsername { get; set; }

        public long StatusTimestamp { get; set; }

        public string Reason { get; set; }

        public bool IsBanned { get; set; }

        public string MaskedIPAddress { get; set; }

        public static GroupBannedUserContract ToNotification(GroupBannedUser ban, Group group)
        {
            var contract = new GroupBannedUserContract
            {
                StatusTimestamp = ban.DateStatusChanged.ToEpochMilliseconds(),
                GroupID = ban.GroupID,
                UserID = ban.UserID,
                Username = ban.Username,
                Reason = ban.Reason,
                IsBanned = !ban.IsDeleted,
                RequestorUserID = ban.RequestorID,
                RequestorUsername = ban.RequestorUsername,

                GroupTitle = group.Title
            };

            if (!string.IsNullOrEmpty(ban.IPAddress))
            {
                contract.MaskedIPAddress = "*.*.*" + ban.IPAddress.Substring(ban.IPAddress.LastIndexOf('.'));
            }

            return contract;
        }

        public static GroupBannedUserContract ToNotification(GroupBannedUserSearchModel ban, Group group)
        {
            var contract = new GroupBannedUserContract
            {
                StatusTimestamp = ban.StatusTimestamp,
                GroupID = ban.GroupID,
                UserID = ban.UserID,
                Username = ban.Username,
                Reason = ban.Reason,
                IsBanned = !ban.IsDeleted,
                RequestorUserID = ban.RequestorUserID,
                RequestorUsername = ban.RequestorUsername,

                GroupTitle = group.Title
            };

            if (!string.IsNullOrEmpty(ban.IPAddress))
            {
                contract.MaskedIPAddress = "*.*.*" + ban.IPAddress.Substring(ban.IPAddress.LastIndexOf('.'));
            }

            return contract;
        }
    }
}
