﻿using Curse.Friends.MicroService;
using Curse.Friends.Data;

namespace Curse.Friends.GroupsWebService.Contracts
{
    public class GroupMemberNicknameRequest : BaseRequestContract
    {
        public string Nickname { get; set; }

        protected override bool DoValidate()
        {
            if (string.IsNullOrWhiteSpace(Nickname))
            {
                _validationMessage = "An empty nickname? No way!";
                return false;
            }

            if (!GroupMember.IsValidUserName(Nickname))
            {
                _validationMessage = "Only alphanumeric nicknames are currently supported.";
                return false;
            }

            return true;
        }
    }
}
