﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using Curse.Extensions;
using Curse.Friends.Data;
using Curse.Friends.MicroService;
using Curse.Friends.Enums;

namespace Curse.Friends.GroupsWebService.Contracts
{
    public class GroupMemberSearchRequest : BaseRequestContract
    {
        public string Username { get; set; }
        public int? RoleID { get; set; }
        public int? PageSize { get; set; }
        public int? Page { get; set; }
        public GroupMemberSearchSortType? SortType { get; set; }
        public bool? SortAscending { get; set; }

        protected override bool DoValidate()
        {
            if (!Username.SafeRange(0, User.NameMaxLength))
            {
                _validationMessage = "Username";
                return false;
            }

            if (Page.HasValue && (Page.Value < 1 || Page.Value > 10000))
            {
                _validationMessage = "Page";
                return false;
            }

            if (PageSize.HasValue && (PageSize.Value < 10 || PageSize.Value > 100))
            {
                _validationMessage = "PageSize";
                return false;
            }

            return true;
        }
    }
}