﻿using System;
using Curse.Extensions;
using Curse.Friends.MicroService;

namespace Curse.Friends.GroupsWebService.Contracts
{
    public class MarkInappropriateRequest : BaseRequestContract
    {
        public Guid ServerID { get; set; }

        public string Reason { get; set; }

        protected override bool DoValidate()
        {
            if (ServerID == Guid.Empty)
            {
                _validationMessage = "No server specified!";
                return false;
            }

            if (!Reason.SafeRange(0, 1024))
            {
                _validationMessage = "Reason must be 1024 characters or less!";
                return false;
            }

            return true;
        }
    }
}