﻿using System.Linq;
using Curse.Extensions;
using Curse.Friends.Data;
using Curse.Friends.MicroService;

namespace Curse.Friends.GroupsWebService.Contracts
{
    public class ModifyChannelSettingsRequest : BaseRequestContract
    {        
        public string Title { get; set; }        
        public string MessageOfTheDay { get; set; }
        public bool? AllowTemporaryChildGroups { get; set; }
        public bool? ForcePushToTalk { get; set; }
        public bool IsPublic { get; set; }
        public int[] AccessRoles { get; set; }
        public bool HideNoAccess { get; set; }
        public bool HideCallMembersNoAccess { get; set; }

        protected override bool DoValidate()
        {            
            if (!Title.SafeRange(1, Group.ChannelTitleMaxLength))
            {
                _validationMessage = "Title must be between 1 and 64 characters.";
                return false;
            }          

            if (MessageOfTheDay.SafeLength() > Group.MessageOfTheDayMaxLength)
            {
                _validationMessage = "Message of the Day is too long.";
                return false;
            }

            if (IsPublic && AccessRoles.Any())
            {
                _validationMessage = "A public channel cannot have role restrictions.";
                return false;
            }           

            return true;
        }
    }
}