﻿using System.Collections.Generic;
using Curse.Friends.Enums;
using Curse.Friends.MicroService;

namespace Curse.Friends.GroupsWebService.Contracts
{
    public class ModifyGroupRolePermissionsRequest : BaseRequestContract
    {
        public Dictionary<GroupPermissions, GroupPermissionState> PermissionsChanges { get; set; } 

        protected override bool DoValidate()
        {          
            if (PermissionsChanges == null || PermissionsChanges.Count < 1)
            {
                _validationMessage = "no permission changes were specified.";
                return false;
            }

            return true;
        }
    }
}