﻿using System.Collections.Generic;
using Curse.Extensions;
using Curse.Friends.Data;
using Curse.Friends.Enums;
using Curse.Friends.MicroService;

namespace Curse.Friends.GroupsWebService.Contracts
{
    public class ModifyGroupRoleRequest : BaseRequestContract
    {                
        public string Name { get; set; }     
        public int VanityColor { get; set;}
        public int VanityBadge { get; set; }
        public bool HasCustomVanityBadge { get; set; }
        public Dictionary<GroupPermissions, GroupPermissionState> Permissions { get; set; } 
        
        protected override bool DoValidate()
        {
                        
            if (VanityColor < 0 || VanityColor > GroupRole.MaxVanityColors)
            {
                _validationMessage = "Vanity color cannot be 0";
                return false;
            }

            if (VanityBadge < 0 || VanityBadge > GroupRole.MaxVanityBadges)
            {
                _validationMessage = "Vanity badge must be a valid range.";
                return false;
            }

            if (!Name.SafeRange(1, GroupRole.NameMaxLength))
            {
                _validationMessage = "Role name cannot be longer than " + GroupRole.NameMaxLength + " characters!";
                return false;
            }

            if (Permissions == null || Permissions.Count > Group.MaxPermissions)
            {
                _validationMessage = "Permissions must be defined, and contain an appropriate number of permissions.";
                return false;
            }
            
            return true;
        }
    }
}