﻿using Curse.Extensions;
using Curse.Friends.Data;
using Curse.Friends.MicroService;

namespace Curse.Friends.GroupsWebService.Contracts
{
    public class ModifyGroupSettingsRequest : BaseRequestContract
    {
        public string Title { get; set; }
        public string MessageOfTheDay { get; set; }
        public bool? ForcePushToTalk { get; set; }
        
        protected override bool DoValidate()
        {
            if (!Title.SafeRange(1, Group.TitleMaxLength))
            {
                _validationMessage = "Title is too long.";
                return false;
            }

            if (!MessageOfTheDay.SafeRange(0, Group.MessageOfTheDayMaxLength))
            {
                _validationMessage = "MessageOfTheDay is invalid or too long.";
                return false;
            }

            return true;
        }
    }
}