﻿using System;
using System.Linq;
using Curse.Friends.Data;
using Curse.Friends.MicroService;

namespace Curse.Friends.GroupsWebService.Contracts
{
    public class ReorganizeGroupRequest : BaseRequestContract
    {
        public GroupDisplayCategory[] DisplayCategories { get; set; }

        public GroupDisplayOrder[] ChangedGroups { get; set; }

        protected override bool DoValidate()
        {
            if ((ChangedGroups == null || ChangedGroups.Length == 0) && (DisplayCategories == null || DisplayCategories.Length == 0))
            {
                _validationMessage = "No changes present";
                return false;
            }

            if (ChangedGroups != null && ChangedGroups.Any(g => !g.IsValid()))
            {
                _validationMessage = "One or more group has invalid data";
                return false;
            }

            if (DisplayCategories != null && DisplayCategories.Any(g => !g.IsValid()))
            {
                _validationMessage = "One or more category has invalid data";
                return false;
            }

            return true;
        }
    }

    public class GroupDisplayOrder
    {
        public Guid GroupID { get; set; }

        public Guid ParentID { get; set; }

        public int DisplayOrder { get; set; }

        public Guid CategoryID { get; set; }

        public bool IsValid()
        {
            return GroupID != Guid.Empty && ParentID != Guid.Empty;
        }
    }

    public class GroupDisplayCategory
    {
        public Guid ID { get; set; }

        public string Name { get; set; }

        public int Rank { get; set; }

        public bool IsValid()
        {
            return ID != Guid.Empty && (Name == null || Name.Length < Group.MaxChannelCategoryNameLength);
        }
    }
}