﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using Curse.Friends.Data.Search;
using Curse.Friends.Enums;
using Curse.Friends.MicroService;

namespace Curse.Friends.GroupsWebService.Contracts
{
    public class SearchBannedUsersRequest : BaseRequestContract
    {
        /// <summary>
        /// The page number
        /// </summary>
        public int? PageNumber { get; set; }

        /// <summary>
        /// The number of results per page
        /// </summary>
        public int? PageSize { get; set; }

        /// <summary>
        /// A general query that matches against searchable fields
        /// </summary>
        public string Query { get; set; }

        /// <summary>
        /// A query against the banned user's username
        /// </summary>
        public string Username { get; set; }

        /// <summary>
        /// A query against the requestor's username
        /// </summary>
        public string RequestorUsername { get; set; }

        /// <summary>
        /// A full-text search against the ban reason
        /// </summary>
        public string Reason { get; set; }

        /// <summary>
        /// Which field the banned users should be sorted against
        /// </summary>
        public GroupBannedUserSortType? SortType { get; set; }

        /// <summary>
        /// Whether or not to sort the banned users in ascending order
        /// </summary>
        public bool? SortAscending { get; set; }

        protected override bool DoValidate()
        {
            if (PageSize.HasValue)
            {
                if (PageSize.Value < 0)
                {
                    return false;
                }

                if (PageSize.Value > GroupBannedUserSearchManager.MaxPageSize)
                {
                    return false;
                }
            }

            if (PageNumber.HasValue && PageNumber.Value < 0)
            {
                return false;
            }

            return true;
        }
    }
}