﻿using System.Collections.Generic;
using Curse.Extensions;
using Curse.Friends.Data;
using Curse.Friends.Enums;
using Curse.Friends.MicroService;

namespace Curse.Friends.GroupsWebService.Contracts
{
    public class SearchGroupEventsRequest : BaseRequestContract
    {
        public string UsernameQuery { get; set; }

        public GroupEventCategory[] IncludedCategories { get; set; }

        public GroupEventCategory[] ExcludedCategories { get; set; }

        public GroupEventType[] IncludedEventTypes { get; set; }

        public GroupEventType[] ExcludedEventTypes { get; set; }

        public int? PageSize { get; set; }

        public int? PageNumber { get; set; }

        public bool? SortAscending { get; set; }

        public GroupEventSearchSortType? SortType { get; set; }

        protected override bool DoValidate()
        {
            if (IncludedCategories != null && ExcludedCategories != null && new HashSet<GroupEventCategory>(IncludedCategories).Overlaps(ExcludedCategories))
            {
                _validationMessage = "Some categories are both included and excluded";
                return false;
            }

            if (IncludedEventTypes != null && ExcludedEventTypes != null && new HashSet<GroupEventType>(IncludedEventTypes).Overlaps(ExcludedEventTypes))
            {
                _validationMessage = "Some event types are both included and excluded";
                return false;
            }

            if (!UsernameQuery.SafeRange(0, User.NameMaxLength))
            {
                _validationMessage = "Username entered is too long";
                return false;
            }

            return true;
        }
    }
}