﻿using Curse.Friends.Data.Search;
using Curse.Friends.Enums;
using Curse.Friends.MicroService;

namespace Curse.Friends.GroupsWebService.Contracts
{
    public class SearchServersRequest : BaseRequestContract
    {
        public string Query { get; set; }
        
        public int? PageNumber { get; set; }
        
        public int? PageSize { get; set; }

        public string GroupTitle { get; set; }

        public string OwnerUsername { get; set; }

        public int? MinMemberCount { get; set; }

        public int? MaxMemberCount { get; set; }

        public GroupSearchTag[] Tags { get; set; }

        public bool? IsPublic { get; set; }

        public int[] Games { get; set; }

        public GroupSearchSortType? SortType { get; set; }

        public bool? SortAscending { get; set; }

        public bool? IsFeatured { get; set; }

        public bool? IsStreaming { get; set; }

        public bool IncludeInappropriateContent { get; set; }

        public GroupSubType? SubType { get; set; }
        
        protected override bool DoValidate()
        {
            if (PageNumber.HasValue && PageNumber.Value < 0)
            {
                _validationMessage = "PageNumber must be non-negative.";
                return false;
            }

            if(PageSize.HasValue && (PageSize.Value<1 || PageSize.Value>GroupSearchManager.MaxPageSize))
            {
                _validationMessage = string.Format("PageSize must be between {0} and {1}", 1, GroupSearchManager.MaxPageSize);
                return false;
            }

            if (MinMemberCount.HasValue && MinMemberCount.Value<1)
            {
                _validationMessage = "MinMemberCount must be positive if specified.";
                return false;
            }

            if (MaxMemberCount.HasValue && MaxMemberCount.Value < 1)
            {
                _validationMessage = "MaxMemberCount must be positive if specified";
                return false;
            }

            if (MinMemberCount.HasValue && MaxMemberCount.HasValue && MinMemberCount.Value > MaxMemberCount.Value)
            {
                _validationMessage = "MinMemberCount must be less than or equal to MaxMemberCount if both are specified.";
                return false;
            }

            return true;
        }
    }
}