﻿using System;
using Curse.Extensions;
using Curse.Friends.Data;
using Curse.Friends.Enums;
using Curse.Friends.MicroService;

namespace Curse.Friends.GroupsWebService.Contracts
{
    public class ServerGeneralSettingsContract : BaseRequestContract
    {
        public string Title { get; set; }
        public Guid? AfkChannel { get; set; }
        public int AfkTimeMinutes { get; set; }
        public VoiceRegion VoiceRegion { get; set; }
        public bool IsPublic { get; set; }
        public int ChatThrottleSeconds { get; set; }
        public bool ChatThrottleEnabled{ get; set; }

        protected override bool DoValidate()
        {
            if (Title != null && (Title.SafeLength() < 1 || Title.SafeLength() > Group.TitleMaxLength))
            {
                _validationMessage = "Title is too long!";
                return false;
            }

            if (AfkTimeMinutes < 0 || AfkTimeMinutes > 480)
            {
                _validationMessage = "AfkTimeMinutes is invalid.";
                return false;
            }
            if (ChatThrottleSeconds < 0 || ChatThrottleSeconds > 300)
            {
                _validationMessage = "ChatThrottleSeconds is invalid.";
                return false;
            }
            
            return true;
        }
    }
}