﻿using System;
using Curse.Extensions;
using Curse.Friends.Data;
using Curse.Friends.Enums;
using Curse.Friends.MicroService;

namespace Curse.Friends.GroupsWebService.Contracts
{
    public class ServerSearchSettingsContract : BaseRequestContract
    {
        public bool IsSearchable { get; set; }
        public string Description { get; set; }
        public GroupSearchTag[] SearchTags { get; set; }
        public int[] Games { get; set; }
        public bool MatchAllGames { get; set; }
        
        protected override bool DoValidate()
        {
            if (!Description.SafeRange(0, GroupSearchSettings.MaxDescription))
            {
                _validationMessage = "Description is too long";
                return false;
            }

            if (SearchTags == null || SearchTags.Length > Enum.GetValues(typeof(GroupSearchTag)).Length)
            {
                _validationMessage = "Missing or too many search tags.";
                return false;
            }

            if (Games == null || Games.Length > GroupSearchSettings.MaxGames)
            {
                _validationMessage = "Missing or too many games.";
                return false;
            }
            
            return true;
        }
    }
}