﻿using System.Collections.Generic;
using Curse.Friends.GroupsWebService.Contracts;
using Curse.Friends.MicroService;

namespace Curse.Friends.GroupsWebService.Utils
{
    public class GroupInvitationWordSet
    {
        private static readonly HashSet<string> _wowWords;

        static GroupInvitationWordSet()
        {
            _wowWords = new HashSet<string>(ConfigHelper.ReadLines("wow_words.txt"));
        }

        public static HashSet<string> Get(GroupInvitationReadableWordCategory category)
        {
            switch (category)
            {
                case GroupInvitationReadableWordCategory.WorldOfWarcraft:
                    return _wowWords;
                default:
                    return null;
            }
        } 
    }
}