﻿using System.Text.RegularExpressions;
using Curse.Friends.Data.Models;

namespace Curse.Friends.GroupsWebService.Utils
{
    public static class VanityUrlValidator
    {
        private static readonly Regex ValidUrl = new Regex(@"^[a-zA-Z0-9_]{3,32}$");

        public static bool IsValid(string url)
        {
            if (string.IsNullOrWhiteSpace(url))
            {
                return false;
            }

            if (url.StartsWith("_"))
            {
                return false;
            }

            return ValidUrl.IsMatch(url);
        }

        public static bool IsAvailable(string url)
        {
            return !VanityUrl.Exists(url);
        }
    }
}