﻿using System.Collections.Generic;
using System.Drawing;
using System.Drawing.Imaging;
using System.Linq;

namespace Curse.Friends.ImageManager
{
    public static class DrawingExtensions
    {
        private static readonly Dictionary<ImageFormat, string> ImageTypes = new Dictionary<ImageFormat, string>
        {
            {ImageFormat.Bmp, "bmp"},
            {ImageFormat.MemoryBmp, "bmp"},
            {ImageFormat.Emf, "emf"},
            {ImageFormat.Wmf, "wmf"},
            {ImageFormat.Gif, "gif"},
            {ImageFormat.Jpeg, "jpeg"},
            {ImageFormat.Png, "png"},
            {ImageFormat.Tiff, "tiff"},
            {ImageFormat.Exif, "exif"},
            {ImageFormat.Icon, "ico"},
        };

        public static string ImageType(this Image image)
        {
            string type;
            if (!ImageTypes.TryGetValue(image.RawFormat, out type))
            {
                type = "";
            }
            return type;
        }

        public static string GetMimeType(this Image image)
        {
            var codecs = ImageCodecInfo.GetImageDecoders();
            var properCodec = codecs.FirstOrDefault(c => c.FormatID == image.RawFormat.Guid);
            return properCodec != null ? properCodec.MimeType : null;
        }
    }
}
