﻿using System;
using System.IO;
using System.Runtime.Caching;

namespace Curse.Friends.ImageManager
{

    public static class ImageCache
    {
        public static TimeSpan CacheDuration { get; set; }

        private static readonly MemoryCache Cache;

        static ImageCache()
        {
            CacheDuration = TimeSpan.FromMinutes(10);
            Cache = new MemoryCache("ImageCache");
        }

        public static ImageCacheItem GetThumbnail(string fileKey, string requestedFilename, int? width = null, int? height = null, bool? animate = null)
        {
            var cacheKey = "fileKey:" + fileKey
                           + ";fileName:" + requestedFilename
                           + ";width:" + (width ?? 0)
                           + ";height:" + (height ?? 0)
                           + ";animate:" + (animate.HasValue ? animate.Value.ToString() : "none");

            var existing = Cache.Get(cacheKey);
            if (existing != null)
            {
                return (ImageCacheItem) existing;
            }
            string contentType;
            byte[] content;

            var stream = ImageManager.ProcessImage(fileKey, requestedFilename, out contentType, width, height, animate);

            if (stream == null)
            {
                return null;
            }

            using (var memoryStream = new MemoryStream())
            {
                stream.CopyTo(memoryStream);
                content = memoryStream.ToArray();
            }

            var cacheItem = new ImageCacheItem(content, contentType, requestedFilename);
            Cache.Add(cacheKey, cacheItem, new CacheItemPolicy {AbsoluteExpiration = DateTimeOffset.UtcNow.Add(CacheDuration)});
            return cacheItem;
        }
    }
}
