﻿using System.Collections.Generic;
using System.Xml.Serialization;

namespace Curse.Friends.ImageManager
{
    [XmlType("ImageManager")]
    public class ImageManagerConfiguration
    {
        public static ImageManagerConfiguration Global { get; set; }

        public static ImageManagerBucketConfiguration Current { get; set; }

        [XmlElement()]
        public int MaxThumbnailWidth
        {
            get;
            set;
        }

        [XmlElement()]
        public int MinThumbnailWidth
        {
            get;
            set;
        }

        [XmlElement()]
        public int MinImageDimension
        {
            get;
            set;
        }

        [XmlElement]
        public int MaxImageDimension
        {
            get; 
            set;
        }

        [XmlArray()]
        [XmlArrayItem("ImageType")]
        public HashSet<string> AllowedImageTypes { get; set; }

        [XmlElement("Bucket")]
        public ImageManagerBucketConfiguration[] Buckets { get; set; }
    }
}
