﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Xml.Serialization;
using Curse.Friends.Configuration;
using Curse.Friends.MicroService;

namespace Curse.Friends.ImagesWebService.Configuration
{
    [XmlRoot("ImageService")]
    public class ImageServiceConfiguration
    {
        private static readonly ImageServiceConfiguration _instance;
        public static ImageServiceConfiguration Instance { get { return _instance;} }

        static ImageServiceConfiguration()
        {
            _instance = ConfigHelper.LoadConfig<ImageServiceConfiguration>(FriendsServiceConfiguration.Mode, "ImageService");
        }

        [XmlElement]
        public bool CloudFlareEnabled { get; set; }

        [XmlElement]
        public string CloudFlareApiKey { get; set; }

        [XmlElement]
        public string CloudFlareEmail { get; set; }

        [XmlElement]
        public string CloudFlareDomain { get; set; }
    }
}